package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.ImageObserver;
import java.io.BufferedWriter;

public class YellowEnemyScreenObject extends MobileScreenObject implements CloneableScreenObject {

private IntRect clickRect;
	
	private boolean isSelected;
	
	public static final int ENEMY_WIDTH = 64;
	public static final int ENEMY_HEIGHT = 64;
	
	
	private static CustomImageDataII yellowEnemyImage;
	
	
	private static synchronized void loadRedEnemyImage(ImageObserver io) {
		
		yellowEnemyImage = new CustomImageDataII("/images/enemy/yellow/elemental L yellow 1.GIF", Color.white, io);
		
	}
	
	
	public YellowEnemyScreenObject(int x, int y, ImageObserver io) {
		
		if(yellowEnemyImage == null) {
			loadRedEnemyImage(io);
		}
		
		clickRect = new IntRect(x - ENEMY_WIDTH/2, y - ENEMY_HEIGHT/2, ENEMY_WIDTH, ENEMY_HEIGHT);
		isSelected = false;
		
		this.setVertical(false);
		
		this.setMin(x);
		this.setMax(x);
		
	}
	
	
	public YellowEnemyScreenObject(int x, int y, ImageObserver io, int min, int max) {
		
		if(yellowEnemyImage == null) {
			loadRedEnemyImage(io);
		}
		
		clickRect = new IntRect(x - ENEMY_WIDTH/2, y - ENEMY_HEIGHT/2, ENEMY_WIDTH, ENEMY_HEIGHT);
		isSelected = false;
		
		this.setVertical(false);
		
		this.setMin(min);
		this.setMax(max);
		
	}
	
	
	
	@Override
	public void draw(Graphics g) {
		if(yellowEnemyImage != null) {
			
			Point center = clickRect.getCenter();
			
			Color origColor = g.getColor();
			
			g.setColor(new Color(0, 255, 0));
			g.drawLine(center.x, center.y - 5, this.getMin(), center.y - 5);
			g.drawLine(center.x, center.y + 5, this.getMin(), center.y + 5);
			
			g.setColor(new Color(51, 255, 0));
			g.drawLine(center.x, center.y - 4, this.getMin(), center.y - 4);
			g.drawLine(center.x, center.y + 4, this.getMin(), center.y + 4);
			
			g.setColor(new Color(102, 255, 0));
			g.drawLine(center.x, center.y - 3, this.getMin(), center.y - 3);
			g.drawLine(center.x, center.y + 3, this.getMin(), center.y + 3);
			
			g.setColor(new Color(153, 255, 0));
			g.drawLine(center.x, center.y - 2, this.getMin(), center.y - 2);
			g.drawLine(center.x, center.y + 2, this.getMin(), center.y + 2);
			
			g.setColor(new Color(204, 255, 0));
			g.drawLine(center.x, center.y - 1, this.getMin(), center.y - 1);
			g.drawLine(center.x, center.y + 1, this.getMin(), center.y + 1);
			
			g.setColor(new Color(255, 255, 0));
			g.drawLine(center.x, center.y, this.getMin(), center.y);
			g.drawLine(this.getMin(), center.y - 10, this.getMin(), center.y + 10);
			
			
			
			g.setColor(new Color(0, 0, 255));
			g.drawLine(center.x, center.y - 5, this.getMax(), center.y - 5);
			g.drawLine(center.x, center.y + 5, this.getMax(), center.y + 5);
			
			g.setColor(new Color(51, 0, 255));
			g.drawLine(center.x, center.y - 4, this.getMax(), center.y - 4);
			g.drawLine(center.x, center.y + 4, this.getMax(), center.y + 4);
			
			g.setColor(new Color(102, 0, 255));
			g.drawLine(center.x, center.y - 3, this.getMax(), center.y - 3);
			g.drawLine(center.x, center.y + 3, this.getMax(), center.y + 3);
			
			g.setColor(new Color(153, 0, 255));
			g.drawLine(center.x, center.y - 2, this.getMax(), center.y - 2);
			g.drawLine(center.x, center.y + 2, this.getMax(), center.y + 2);
			
			g.setColor(new Color(204, 0, 255));
			g.drawLine(center.x, center.y - 1, this.getMax(), center.y - 1);
			g.drawLine(center.x, center.y + 1, this.getMax(), center.y + 1);
			
			g.setColor(new Color(255, 0, 255));
			g.drawLine(center.x, center.y, this.getMax(), center.y);
			g.drawLine(this.getMax(), center.y - 10, this.getMax(), center.y + 10);
			
			
			
			g.setColor(origColor);
			
			yellowEnemyImage.drawObjectFromUpperLeftCorner(g, clickRect.getMinX(), clickRect.getMinY());
		}

		drawInitialDirIndicator(g);
		
		if(isSelected)
			drawSelectionOverObject(g);
		
		
		
		
	}

	@Override
	public IntRect getClickRect() {
		return clickRect;
	}

	@Override
	public void setSelected(boolean is) {
		isSelected = is;
	}

	@Override
	public boolean isSelected() {
		return isSelected;
	}


	@Override
	public void setClickRect(IntRect newRect) {
		// TODO Auto-generated method stub
		
	}
	
	public void writeOutToFile(BufferedWriter out) throws Exception{
		
		out.write("enemy:");
		out.newLine();
		
		Point centerPoint = clickRect.getCenter();
		
		out.write("x:");
		out.write(Integer.toString(centerPoint.x));
		out.newLine();
		
		out.write("y:");
		out.write(Integer.toString(centerPoint.y));
		out.newLine();
		
		out.write("yellow");
		out.newLine();
		
		out.write("minX:");
		out.write(Integer.toString(this.getMin()));
		out.newLine();
		
		out.write("maxX:");
		out.write(Integer.toString(this.getMax()));
		out.newLine();
		
		
		out.write("dir:");
		if(this.isGoingMinDirection()) {
			out.write("l");
		} else {
			out.write("r");
		}
		out.newLine();
		
		out.write("/enemy");
		out.newLine();
		
		out.newLine();
	}

	
	public YellowEnemyScreenObject clone(ImageObserver io) {
		
		Point centerPoint = clickRect.getCenter();
		
		YellowEnemyScreenObject returnValue = new YellowEnemyScreenObject(centerPoint.x, centerPoint.y, io);
		returnValue.setMax(this.getMax());
		returnValue.setMin(this.getMin());
		returnValue.setGoingMinDirection(this.isGoingMinDirection());
		returnValue.setPaletteObject(this.getPaletteObject());
	
		return returnValue;
		
		
	}


	@Override
	public int getLayer() {
		
		return 14;
	}
}
